//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2015 BY HOLTEK SEMICONDUCTOR INC
//  File Name : MasterII.h
// Description: IO模擬IIC主機
//     Note   : ROM SIZE 230 RAM 依據接收發送BUF不同大小不一,最小約15Byte以上
//___________________________________________________________________
//___________________________________________________________________

#ifndef _IIC_MasterIIC_H
#define _IIC_MasterIIC_H
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Userdefine @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// IIC CLOCK
#define	IIC_SPEED	30          // IIC Clock = 1/( instruction cycles*N)
// IIC Slave Address
#define IIC_ADDRESS 0xD0        // IIC Slave Address
// IIC SDA
#define IIC_SDA_OUTPUTMODE()    { _pdc0 = 0;}
#define IIC_SDA_INPUTMODE()     { _pdc0 = 1;}
#define IIC_SDA_OUTPUTHIGH()    { _pdc0 = 1;}
#define IIC_SDA_OUTPUTLOW()     { _pd0  = 0;}
#define IIC_SDA_ISHIGH()          _pd0 == 1
#define IIC_SDA                   _pd0
// IIC SCL
#define IIC_SCL_OUTPUTMODE()    { _pdc1 = 0;}
#define IIC_SCL_INPUTMODE()     { _pdc1 = 1;}
#define IIC_SCL_OUTPUTHIGH()    { _pd1  = 1;}
#define IIC_SCL_OUTPUTLOW()     { _pd1  = 0;}


typedef struct
{
	union
	{
		struct
		{
            unsigned char ByteRes;		// R ADC 預留位
            unsigned char ByteLow;		// R ADC 原始數據低位
            unsigned char ByteMid;		// R ADC 原始數據中位
            unsigned char ByteHigh;		// R ADC 原始數據高位
		}byte;
		long ADCData;
	}data;
	unsigned char SamplingCnt;	// R ADC 採集次數計數
	union {
		struct
		{
			unsigned char IsReady : 1;  // R 有一筆原始ADC數據
			unsigned char IsCheck : 1;  // R 有一筆可以去IIC讀取
		} b;
		unsigned char byte;
	} flag;
} ADCSource_t;
extern volatile ADCSource_t ADCSourceData;

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用函數 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
unsigned char Drv_24BitADC_ReadReg(unsigned char RegAddress);
void Drv_24BitADC_WriteReg(unsigned char RegAddress, unsigned char RegData);
void Drv_24BitADC_ReadADCData();
void Drv_24BitADC_Init();
void Drv_24BitADC_Start();
void Drv_24BitADC_Stop();
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用變量 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define VCMEN	1	// 0 Disable 1 enable
#define FADCK   0x28// 0x28 Fadck = Fmclk/30   0x2C Fadck = Fmclk/12

#define AGS    0	//  ADC GAIN (0 GAIN_1   1 GAIN_2)
#define VGS    0	//  VREF GAIN (0 GAIN_1   1 GAIN_0.5, 2 GAIN_0.25)
#define PGS    5	//  PGA GAIN (0 GAIN_1   1 GAIN_2  2 GAIN_4  3 GAIN_8  4 GAIN_16  5 GAIN_32 6 GAIN_64)

#define INIS  0		// input Short(0 Disable  1 Enable)
#define INX	  0		// Input change(0 nochange 1 short IN2   2 Short IN1  3 exchange)
#define DCSET 0		// DCSET(0_0V 1_0.25VR    2_0.5VR   3_0.75VR   5_-0.25VR    6_-0.5VR   7_-0.75VR)

#define CHSN  0  	// 0_AN1_24    1_AN3_24   4_VDACO  5_AVSS24  6_VCM 7_VTSN
#define CHSP  0     // 0_AN0_24    1_AN2_24   4_VDACO            6_VCM 7_VTSP

#define ADOR  1		// 0_OSR32768  1_OSR16384  2_OSR8192  3_OSR4096   4_OSR2048  5_OSR1024  6_OSR512  7_OSR256  8_OSR128
#define VREFS 1		// ADC Reference  0 VCM&AVSS  1 VREFP&VREFN

#define FLMS  0		// 0 N=30  2 N=12
#define VRBUF 0     // Reference Buf 0 Disable  3 Enable
#define ADCSN  0x1F

#define PWRC    0x00
#define PGAC0   0x01
#define PGAC1   0x02
#define PGACS   0x03
#define ADRL    0x04
#define ADRM    0x05
#define ADRH    0x06
#define ADCR0   0x07
#define ADCR1   0x08
#define ADCS    0x09
#define ADCTE   0x0A
#define DAH     0x0B
#define DAL     0x0C
#define DACC    0x0D
#define SIMC0   0x0E
#define SIMTOC  0x10
#define HIRCC   0x11





#endif